
* ==============================================================================
* ICPSR Summer 2021
* Maximum Likelihood Estimation 1: General Linear Models 
* Reshaping Data
* Created by: 	Semra Sevi
* ==============================================================================

* Import test dataset 

use "test.dta"

* This dataset has 3 different individuals (identified by id). We also have
* information about whether they voted in the 2020 presidential election, if 
* they are married, their gender, party id, vote choice and feeling thermometer 
* for Trump and Biden.

* First we need to rename our variables in the format Stata requires them in 
* order to use reshape which will stack our data. For it to work, 
* the data to be stacked needs to be stored in variables with a specific name format. 
* For each variable that will be stacked together into a new variable the name 
* has to start in the same way (we call this a stub) and it needs to end with a number. 
* So when we go from wide to long every variable with the same stub gets 
* stacked into a new variable whose name is stub and another new variable is created, 
* whose values are the numbers appended to the stub in the original variable names, 
* which allows us to identify the alternative. 

rename trump_ft ft1
rename biden_ft ft2

* Now lets reshape our data to long. Note the variables after "reshape long" 
* but before the comma are the variables we want to reshape, i is the identifier 
* for the individual. j is the new variable. Let's call it candidate because its
* values indicate the candidate with which the row is associated. 

reshape long ft, i(id) j(candidate)
